;QUESTION FOR JIM - what sort of assumptions are made about residents per house - or are we simply stating the number of residential cells entering
; need to have conversion between residential cells and residents - say 2.5 residents per cell
extensions [ gis ]

globals [
  Year
  neighbor-count
  jurisdictions
  goal-level-of-service
  urban-val
  park-val
  developable-val
  undevelopable-val
]

;NOT SURE WHERE I SHOULD PUT THE PARK DEMAND FOR EACH OF THE JURISDICTIONS

patches-own [
  residential-attractiveness  ; read in from map value range is ... ?
  park-attractiveness         ; read in from map value range is ... ?
  NLCD                        ; read in from map - 1990's NLCD categories?
  jurisdiction    ;jurisdiction variable
  park-map
  res-dev-prob
  park-dev-prob   ;park development probability
  new-residential ;identifies that the patch holds residential that has been created by the model (1 - just new; 2 - old new)
  new-park        ;identifies that the patch holds parks that has been created by the model (1 - just new; 2 - old new)
  tmp
]

;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
to initialize
  ca
  initialize-global-variables
  initialize-maps
  initialize-patches
  initialize-edge-patches ; Ring the map with a no-mans-land
    ; create a list of jurisdiction values by looking at the jurisdiction values associated with patches
  set jurisdictions sort remove-duplicates [ jurisdiction ] of patches

  do-plot
  set map-display "NLCD"
  show-map
  set map-display "New-Residential"
  ; set map-display "New-Parks"
end

to initialize-global-variables
  set Year 0
  set urban-val 1
  set park-val 2
  set developable-val 3
  set undevelopable-val 4

end

to initialize-maps
  ; to-do and to-consider
  ;  Perhaps the NLCD map needs to come in with our unique land cover values - including location of parks?
  ;  Need a jurisdiction map - below the bottom top of the map is jurisdiction 1 and bottom half 2
  
  ;; Read these from maps
  gis:apply-raster (gis:load-dataset "maps/res-attr.asc")  residential-attractiveness
  gis:apply-raster (gis:load-dataset "maps/NLCD.asc")      NLCD
  gis:apply-raster (gis:load-dataset "maps/res-attr.asc")  park-attractiveness
  ; gis:apply-raster (gis:load-dataset "maps/parkmap.asc")   park-map
  ; gis:apply-raster (gis:load-dataset "maps/parkjurisdiction.asc")   jurisdiction
  ask patches [ ifelse pxcor > 350 [set jurisdiction 1 ] [ set jurisdiction 2] ]
  ; Convert the NLCD categories to our simpler values
  ask patches
  [ 
    if ( NLCD > 90 OR NLCD = 11 ) [ set NLCD undevelopable-val ]
    if ( NLCD > 30 AND NLCD < 85 AND park-map != 1 ) [ set NLCD developable-val ]
    if ( NLCD > 20 AND NLCD < 30 AND park-map != 1 ) [ set NLCD urban-val ]
    if ( NLCD = 2 ) [ set NLCD park-val ]
  ]
end

to initialize-patches
  ask patches [
    set new-residential 0
    set new-park 0
  ]
end

to initialize-edge-patches
  let x min-pxcor
  while [ x <= max-pxcor ]
  [
    ask patch x max-pycor [ zero-out ]
    ask patch x min-pycor [ zero-out ]
    set x x + 1
  ]
  let y min-pycor
  while [ y <= max-pycor ]
  [
    ask patch max-pxcor y [ zero-out ]
    ask patch min-pxcor y [ zero-out ]
    set y y + 1
  ]
end

to zero-out             ; This puts a hard edge on the area, which avoids the need for special code for edges
    set res-dev-prob 0
    set park-dev-prob 0
end


;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% MODEL SECTION %%%%%%%%%%%%%%%%%%%%%%%%%%%

to step
  set Year Year + 1
  create-new-residential
  calculate-park-attractiveness
  calculate-park-demand-by-jurisdiction
  create-new-parks-by-jurisdiction
  calculate-residential-attractiveness 
  set map-display "New-Residential"
  show-map
  set map-display "New-Parks"
  show-map
  do-plot
end

to create-new-residential
  ; move recently new residential to "old" new residential
  ask patches with [ new-residential = 1 ]   [ set new-residential 2 ]  ; "2" denotes "old" new residential
  ; Identify patches that could become new urban
  let res-patch-list patches with [ NLCD = developable-val ]                         ; get list of potential development sites
  ; Calculate their attractiveness
  ask res-patch-list [ set res-dev-prob  ( ( random-float 1.0 ) ^ res-rand-factor  * residential-attractiveness ^  res-factor ) ]
  ; Sort by attractiveness
  set res-patch-list sort-by [[res-dev-prob] of ?1 > [res-dev-prob] of ?2] res-patch-list   ; sort patch list by park dev prob 

  let i 0  
  let res-patch-num 0
  let l length res-patch-list
  
  ifelse (neighborhoods)
  [
    while [ i < res-per-year AND res-patch-num < l ]  
    [
      set neighbor-count 0
      ask ( item res-patch-num res-patch-list ) [ grow-neighborhoods neighborhood-size ]
      set i i + neighbor-count
      set res-patch-num res-patch-num + 1
    ]
  ]
  [  ; If neighborhoods are not being built
    while [ i < res-per-year AND res-patch-num < l ]  
    [ 
      ask ( item res-patch-num res-patch-list )
      [ 
        if ( new-residential = 0 )
        [
          set i i + 1
          set new-residential 1
          set NLCD urban-val
        ]
      ]
      set res-patch-num res-patch-num + 1
    ] 
  ]
end

to grow-neighborhoods [ total ]
  if ( NLCD = developable-val AND new-residential = 0 )
  [ 
    set NLCD urban-val
    set new-residential 1
    set neighbor-count neighbor-count + 1
    if neighbor-count < total
    [ ask neighbors [ grow-neighborhoods total ] ]
  ]
end

to calculate-park-attractiveness
; add extra attractiveness to each cell surrounding patches that are new-residential
  print "calculating park attractiveness"
  type count patches with [ new-residential = 1 ]
  print " patches with new-residential"
  ask patches with [ new-residential = 1 ]
  [
    ask neighbors [ if (park-attractiveness >= 0 OR park-attractiveness <= 0) [ set park-attractiveness (park-attractiveness + (urban-effect-on-parks * ( 1.0 - park-attractiveness ) ) ) ] ]
  ]
end

to calculate-park-demand-by-jurisdiction
  set goal-level-of-service []  ; start an empty list

  foreach jurisdictions 
  [
    let new-urban ( count patches with [ jurisdiction = ? AND new-residential = 1 ] )
    let parks-needed new-urban * item ( ? - 1 ) read-from-string park-residential-ratio
    set goal-level-of-service lput parks-needed goal-level-of-service
  ]
  
; [ jurisdictions goal-level-of-service[i]]  ;Jim - as you'll see, I don't know how arrays work in NetLogo
; clear old variables?  Not sure if I need to, of which ones I need to clear.
; read in map of jurisdictions - map must be raster map (matching extent + projection of study area maps) and must have all cells in jurisdiction given by numeric value
;NOT SURE IF I NEED TO DO ANYTHING ELSE IN THE initialize-park-demand-queues function for reading in this map since it is done with the other maps below
; let i 1  
; while [ i <= jurisdictions ] ;trying to bring in a group of all the populations and goal LEVEL OF SERVICE (LOS) for each jurisdiction
;    [ 
;       set goal-level-of-service-cell[i] = goal-level-of-service[i]/0.22239484332  ;conversion between acres and 30mx30m cells - goal-level-of-service given as acres/(1000 pop) - convert to cells/1000 pop
;    ]  
end
  
to create-new-parks-by-jurisdiction
  foreach jurisdictions
  [
    type "creating parks for jurisdiction " type ? type " with goal-level " print item (? - 1) goal-level-of-service
    create-new-parks ? ( item (? - 1) goal-level-of-service )
  ]
end

to create-new-parks [ juris num-cells ]
  ; upgrade recent new parks to "old" new parks
  ask patches with [ new-park = 1 ]   [ set new-park 2 ]  ; "2" denotes "old" new park
  ; Identify patches that could become parks
  let park-list patches with [ jurisdiction = juris AND NLCD = developable-val ]
  print count park-list
  ; Calculate their attractiveness
  ask park-list [ set park-dev-prob ( ( random-float 1.0 ) ^ park-rand-factor + park-attractiveness ^ park-factor ) ]
  ; Sort by attractiveness
  set park-list sort-by [[park-dev-prob] of ?1 > [park-dev-prob] of ?2] park-list

  let i 0  
  let park-patch-num 0
  let l length park-list
  
  ifelse (park-clump)
  [
    while [ i < num-cells AND park-patch-num < l ]  
    [
      set neighbor-count 0
      ask ( item park-patch-num park-list ) [ grow-parks neigh-park-size ]
      set i i + neighbor-count
      set park-patch-num park-patch-num + 1
    ]
  ]
  [  ; If clumps are not being built
    while [ i < num-cells AND park-patch-num < l ]  
    [ 
      ask ( item park-patch-num park-list )
      [ 
        if ( new-park = 0 )
        [
          set i i + 1
          set new-park 1
          set NLCD park-val
        ]
      ]
      set park-patch-num park-patch-num + 1
    ] 
  ]
 end
 
to grow-parks [ total ]
  if ( NLCD = developable-val AND new-park = 0 )
  [ 
    set NLCD park-val
    set new-park 1
    set neighbor-count neighbor-count + 1
    if neighbor-count < total
    [ ask neighbors [ grow-parks total ] ]
  ]
end

to  calculate-residential-attractiveness
; add extra attractiveness to each cell surrounding patches that are new-parks
  ask patches with [ new-park = 1 ]
  [
    ask neighbors [ if (residential-attractiveness >= 0 OR residential-attractiveness <= 0) [ set residential-attractiveness (residential-attractiveness + ( park-effect-on-urban * ( 1.0 - residential-attractiveness ) ) ) ] ]
  ]
end

;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% BEGIN RECURSIVE GROWTH AND PARK CALCULATION SUB-SECTION%%%%%%%%%%%%%%%%%%%%%%%%%%%

;CALCULATE CONTINUING DEMAND FOR PARK LAND IN EACH JURISDICTION


;to calculate-park-demand [ population[i] count-new-res-cells[i] goal-level-of-service-cell[i] ]  ;goal-level-of-service-cell[i] calculated in the initialization function above
;   population[i] = population[i] + count-new-res-cells[i] * residents-per-HH  ;update population to new values given new residents
;   c-LOS-cell[i] = current park-map-cell-count[i] / (population[i] + /1000) ; Calculate c-LOS [current level of service]
;   elseif (goal-level-of-service-cell[i]>c-LOS-cell[i])                                      ; Calculate initial open space demand for each jurisdiction
;     [park-demand[i] = (goal-level-of-service-cell[i] - c-LOS-cell[i]) * (population[i]/1000)
                ;This is where to insert a delay function as shown in the paper - perhaps put some sort of smooth function on the amount of parks built
;     [park-demand[i] = 0]
;end

;to grow-comm-parks [ totalp ]
;  if ( NLCD > 30 AND NLCD < 85 AND park-map != 1 AND new-park = 0 )
;  [ 
;    set new-park 1
;    set pneighbor-count pneighbor-count + 1
;    if pneighbor-count < totalp
;    [ ask neighbors [ grow-comm-parks totalp ] ]
;  ]
;end
;
;to grow-neigh-parks [ totalp ]
;  if ( NLCD > 30 AND NLCD < 85 AND park-map != 1 AND new-park = 0 )
;  [ 
;    set new-park 1
;    set pneighbor-count pneighbor-count + 1
;    if pneighbor-count < totalp
;    [ ask neighbors [ grow-neigh-parks totalp ] ]
;  ]
;end
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% BEGIN RECURSIVE GROWTH AND PARK CALCULATION SUB-SECTION%%%%%%%%%%%%%%%%%%%%%%%%%%%

;%%%%%%%%%%%%%%%%%%%%%%%%%%END OF MODELING SECTION%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


to print-report  
end

;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
; Plot procedures - replicated parks for residential
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

to do-plot
  set-current-plot "New Residential"
  set-current-plot-pen "New Lots" plot ( count patches with [ new-residential != 0 ] )

  set-current-plot "New Parks"
  set-current-plot-pen "New Parks" plot ( count patches with [ new-park != 0 ] )
end

;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
; Utility procedures
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

to-report get-time
  let time date-and-time
  report( read-from-string substring time 0 2 ) * 3600 + 
        ( read-from-string substring time 3 5 ) * 60 + 
        ( read-from-string substring time 6 12 )
end

to show-map ; added park components - including park attractiveness, current parks, and new parks
  if ( map-display = "Res-Attr" )        [ ask patches [ set tmp Residential-attractiveness ] show-int-map ]
  if ( map-display = "Park-Attr" )       [ ask patches [ set tmp park-attractiveness ] show-int-map ]  ;display park attractiveness map
  if ( map-display = "NLCD" )            [ ask patches [ set tmp NLCD ] show-NLCD-map ]
  if ( map-display = "Current-Parks" )   [ ask patches [ set tmp park-map ] show-int-map ]  ;display current parks
  if ( map-display = "Jurisdictions" )   [ ask patches [ set tmp jurisdiction ] show-int-map ]  ;display current parks
  if ( map-display = "New-Residential" ) [ ask patches with [ new-residential != 0 ] [ set pcolor red ] ]
  if ( map-display = "New-Parks" )       [ ask patches with [ new-park != 0 ] [ set pcolor green ] ]  ;display new parks in green

end

to show-int-map
  let the-max 0
  set the-max max [ tmp ] of patches
  ifelse ( the-max != 0 )
  [ ask patches 
    [ if (tmp >= 0 OR tmp <= 0) [ set pcolor (9.99 - 9.99 * ( tmp / the-max ) ) ] ]
  ]
  [ ask patches [ set pcolor 0 ] ] 
end


to show-NLCD-map
  ask patches
  [
    set pcolor NLCD + 5
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
303
10
1071
758
-1
-1
1.0
1
10
1
1
1
0
1
1
1
0
757
0
716
0
0
1
ticks

CHOOSER
0
562
182
607
map-display
map-display
"Res-Attr" "NLCD" "New-Residential" "New-Parks"
3

BUTTON
188
562
285
607
NIL
show-map
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
2
477
65
510
NIL
step
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
69
477
132
510
run steps
let i 0\nwhile [ i < steps ] [ step   set i i + 1 ]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

MONITOR
1077
204
1127
249
Year
Year
0
1
11

PLOT
1075
409
1370
559
New Residential
Time
30x30m lots
0.0
10.0
0.0
10.0
true
true
PENS
"New Lots" 1.0 0 -2674135 true

SLIDER
158
477
298
510
steps
steps
1
100
20
1
1
steps
HORIZONTAL

TEXTBOX
5
10
242
28
Step 1: Initialize chosen location\n
11
0.0
1

TEXTBOX
2
460
286
478
Step 3: Choose a number of steps to run and run
11
0.0
1

TEXTBOX
-1
529
290
557
At any time, choose a map to display.  Will display on clicking \"show_map\" and at the end of each step.
11
0.0
1

SLIDER
3
172
146
205
res-per-year
res-per-year
0
10000
156
1
1
NIL
HORIZONTAL

SWITCH
151
209
291
242
neighborhoods
neighborhoods
0
1
-1000

SLIDER
3
208
146
241
neighborhood-size
neighborhood-size
1
100
10
1
1
NIL
HORIZONTAL

BUTTON
5
25
151
58
NIL
initialize
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

TEXTBOX
5
70
155
88
Step 2: Set variables
11
0.0
1

SLIDER
5
89
149
122
res-rand-factor
res-rand-factor
0
1
0.29
.01
1
NIL
HORIZONTAL

SWITCH
149
355
278
388
park-clump
park-clump
0
1
-1000

SLIDER
3
355
143
388
neigh-park-size
neigh-park-size
0
100
4
1
1
NIL
HORIZONTAL

PLOT
1075
255
1369
405
New Parks
Time
30x30m lots
0.0
10.0
0.0
10.0
true
true
PENS
"New Parks" 1.0 0 -10899396 true

SLIDER
8
649
180
682
comm-park-size
comm-park-size
0
100
50
1
1
NIL
HORIZONTAL

SLIDER
1144
149
1289
182
Residents-per-HH
Residents-per-HH
0
5
4.5
.5
1
NIL
HORIZONTAL

SLIDER
5
126
149
159
res-factor
res-factor
0
1
1
.01
1
NIL
HORIZONTAL

SLIDER
160
89
301
122
park-rand-factor
park-rand-factor
0
1
0.04
.01
1
NIL
HORIZONTAL

SLIDER
160
126
301
159
park-factor
park-factor
0
1
1
.01
1
NIL
HORIZONTAL

INPUTBOX
5
293
132
353
park-residential-ratio
[.5 .1]
1
0
String

SLIDER
2
243
175
276
urban-effect-on-parks
urban-effect-on-parks
0
1
1
.01
1
NIL
HORIZONTAL

SLIDER
4
391
193
424
park-effect-on-urban
park-effect-on-urban
0
1
1
.01
1
NIL
HORIZONTAL

@#$#@#$#@
WHAT IS IT?
-----------
This is a simple urban residential growth model that provides you with playground for understanding urban growth dynamics and a basis for developing more comprehensive models.

HOW DOES IT WORK?
-----------------

This model uses two input maps.  One is an attractiveness map for driving development and the other is a National Land Cover Data (NLCD) map used as a background. The attractiveness map was developed with a GRASS GIS script that generates an overall attractiveness to residential development value for every location based on the residential pattern in the NLCD map and shortest travel times to things such as urban centers, highways, roads, interstates, trees, and water.  It also considers slope.  This model is generic in the sense that the attractiveness map can provide attractiveness values for anything. 


HOW TO USE IT
-------------
Maps are provided for Champaign, Ill. and Chapel Hill, N.C.  Begin by initializing the model for one of these locations.  Then, select a "res_per_year" value to reflect the number of 30x30 meter locations to develop into residential.  Optionally choose to turn "neighborhoods" on, which forces development to be clumped. Then run the model for as many steps (each a year) as you choose.

EXPERIMENTS
----------------
Run the model with neighborhoods turned off.  Where is development occurring?  In what ways does this development "make sense"?  In what ways might it be "wrong"?

Play with the neighborhood option turned on.  Can you get the model to be more realistic?  Why or why not?

MODIFICATIONS
--------------
Areas are chosen for development based on 1) the attractiveness map (with values in the range of 0-1.0) and 2) on two random numbers.  The first random number (range 0-1.0) is compared with the attractiveness value.  If it is lower, the location is selected for possible development and is assigned a second random number.  Chosen locations are sorted by this second random number and developed in this order.  When the list is exhausted, the process repeats.

For fun consider adding the ability to simply develop the optimal (most attractive) areas first.  Why might this not match "reality"?  Consider adding a slider that moves between 0 (optimal) and 1 (totally random).  What math might accomplish this?

Development attracts development.  How might the current model be modified to increase the attractiveness of model generated land around new development?

EXTENSIONS
-------------
Development of the attractiveness map considered the urban patterns as a whole.  Consider building different attractiveness maps.  For example, low cost housing, shopping, industrial, and expensive low-density residential.  Consider having these compete with one another.

CREDITS AND REFERENCES
----------------------
This model captures notions developed in the creation of the LEAM, SLEUTH, and rSIM models.   This version was developed by Jim Westervelt of the Army Corps' Engineer Research and Development Center.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

link
true
0
Line -7500403 true 150 0 150 300

link direction
true
0
Line -7500403 true 150 150 30 225
Line -7500403 true 150 150 270 225

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
